/*global $:false */

var myfileupload;

function parseURL(url) {

	var parser = document.createElement('a'),
		searchObject = {},
		queries, split, i;

	// Let the browser do the work
	parser.href = url;

	// Convert query string to object
	queries = parser.search.replace(/^\?/, '').split('&');
	for( i = 0; i < queries.length; i++ ) {
		split = queries[i].split('=');
		searchObject[split[0]] = split[1];
	}

	return {
		protocol: parser.protocol,
		host: parser.host,
		hostname: parser.hostname,
		port: parser.port,
		pathname: parser.pathname,
		search: parser.search,
		searchObject: searchObject,
		hash: parser.hash
	};
}

function get_protocol(data_url) {
    var parser = parseURL(data_url);
    return parser.protocol;
}

function get_filename(data_url) {
    var parser = parseURL(data_url);
    return parser.pathname.split("/").pop();
}

function validate_user_data() {
    var validate_result = true;

    if ($("#type_rnaseq").attr("checked") === "checked" || $("#type_chipseq").attr("checked") === "checked") {
        if ($("#organism_row input:checked").length === 0) {
            alert("Please choose one of organisms.");
            $("#organism_row").css("border", "2px solid red");
            validate_result = false;
        }
    }
    /*var data_url = $("#url_list").val();
    if (data_url === undefined) {
        data_url = "";
    }
    if (data_url.trim() !== "") {
        var filename = get_filename(data_url);
        if (!filename.match(/(tar\.gz|\.tar|\.zip|\.tgz)$/i)) {
            alert("Could not find valid filename from your URL. It should be .tar, .tgz, .tar.gz or .zip file.");
            validate_result = false;
        }
    }*/
    return validate_result;
}

function submit_user_data() {
    if ($("#sd").val() == '') {
        alert("ERROR: Failed to set working directory!");
        return false;
    }
    var email = $("#email").val();
    var project = $("#project").val();
    var type = $("#type_row label.active input").val();
    var organism = $("#organism_row label.active input").val() === undefined ? "" : $("#organism_row label.active input").val();
    var mirna = $("#mirna_true input").prop("checked");
    var url_list = $("#url_list").val();
    var srr_list = $("#srr_list").val();
    var sd = $("#sd").val();
    if (url_list === undefined || url_list.trim() === "") {
        url_list = "";
    }

    var submit_url = location.pathname + "/run"

    $(".container").css('height', $(".container").css('height'));
    $(".container").css('width', $(".container").css('width'));
    $(".container").css('border', 'none');
    $(".container").html("<img src=\"/images/loader.gif\" alt=\"loader\">");

    img_margin_top = Math.round($(".container").height()/2 - 33);
    img_margin_left =  Math.round($(".container").width()/2 - 33);
    $(".container img").css('margin-top', img_margin_top + "px");
    $(".container img").css('margin-left', img_margin_left + "px");

    $.post(submit_url, {
        "email": email,
        "project": project,
        "type": type,
        "organism": organism,
        "mirna": mirna,
        "url_list": url_list,
        "sd": sd,
        "srr_list": srr_list,
        "url_list": url_list,
    },
           function(x){
               $("#sd").val("");
               console.log("submission return value");
               console.log(x);
               console.log("---------------------");
               if(x.match(/data_\S+$/) !== null) {
		   //change back to commneted line once https server is setup
                   window.location = "https://" + window.location.hostname + x;
               }
               else {
                   alert(x);
                   $(".container").html(x+"<br><br><h2><a href=''>Go back to main page</a></h2>");
               }
           });
    
}

function validateExpertForm() {
    /* Test if at least one file is submitted */
    if ($("#expr_table").val() === "" || $("#sitecount_table").val() === "") {
        alert("Please provide one file with expression table and one file with sitecount matrix.");
        return false;
    }
    return true;
}
    
function change_fileupload_url() {
    var curr_url = $("#fileupload").attr("action");
    var new_url = curr_url.replace("/fcgi/", "/secure/fcgi/");
    $("#fileupload").attr("action", new_url);
}

function login() {
    var username = $("#username").val();
    var password = $("#password").val();
    var posting = $.post("https://secure.ismara.unibas.ch/mara/login", {
        "username": username,
        "password": password
    }, function(x) {
        if (x === "Log in failed.") {
            $("#login_form #status").html(x);
        }
        else {
            window.location.href = "https://secure.ismara.unibas.ch/mara/"
            /*$("#in").hide();
            $("#login_form #logout").show();
            var data = jQuery.parseJSON(x);
            $("#login_form #status").html("Welcome " + data[0].username + "<ul><li><a href=\"/secure" + location.pathname + "/list\">List jobs</a></li><li><a href=\"" + location.pathname + "/pchng\">Change password</a></li></ul>");
            $("#email").val(data[0].email);
            $("#logged").val("1");
            change_fileupload_url();*/
        }        

    });
}

function logout() {
    var posting = $.post("logout",
                         {},
                         function(x) {
                             if (x === "Ok") {
                                 location.reload()
                                 /*$("#in").show();
                                 $("#login #logout").hide();
                                 $("#login #status").html("");
                                 $("#logged").val("0");*/
                             } else {
                                 $("#logout_status").html("Failed to log out. Please clean the coockies and reload the page.");
                             }
                         });
}


function save_user_data_before_upload() {
    var data = {}
    data.email = $("#email").val();
    data.project = $("#project").val();
    data.type = $("#type_row label.active input").val();
    data.organism = $("#organism_row label.active input").val() === undefined ? "" : $("#organism_row label.active input").val();
    data.mirna = $("#mirna_true input").prop("checked");
    data.url_list = $("#url_list").val();
    data.srr_list = $("#srr_list").val();
    if (data.url_list === undefined || data.url_list.trim() === "") {
        data.url_list = "";
    }
    
    data.submit_url = location.pathname + "/save_json"

    // file names and sizes
    //var a = {}
    //$("tr.template-upload td.name span").each(function(x){a[x] = [$(this).text()]})
    //$("tr.template-upload td.size span").each(function(x){a[x] = a[x].concat([$(this).text()])})

    
    console.log("data for json: " + JSON.stringify(data));
    $.post(data.submit_url, {
        "data": JSON.stringify(data),
        "sd": $("#sd").val()
    },
           function(x){
               console.log(x);
           });
}


function set_sd(callback) {
    var url = window.location.pathname + "/get_sd"
    $.get(url, function(data) {
        if (/^data_\S{6,}$/.test(data)) {
            $("#sd").val(data);
            console.log("SD set to " + data);
            if (typeof callback === "function") {
                callback();
            }
        } else {
            alert("ERROR: Failed to set working directory!");
        }
    });
}


$(function () {
    'use strict';

    //change back to commneted line once https server is setup
    if (window.location.protocol === "http:") {
        window.location = "https://" + window.location.hostname + window.location.pathname;
    }
    
    // Interface show/hide logic
    $("#type_microarray").click(function(){
        $("#fastq_help").collapse("hide");
        $("#organism_row").collapse("hide");
        $("#mirna_row").collapse("show");
        $("#mirna_true").button("toggle")
    });
    $("#type_rnaseq").click(function(){
        $("#organism_row").collapse("show");
        $("#mirna_row").collapse("show");
        $("#fastq_help").collapse("show");
        $("#mirna_true").button("toggle")
        if (window.location.href.search(/\?mm10lncrna/) != -1) {
            $(".mm10lncrna").show();
        }
        $("#organism7").show();
    });
    $(".mm10lncrna input").click(function(){
        $("#mirna_false").button("toggle");    
        $("#mirna_row").collapse("hide");                    
    });

    $("#type_chipseq").click(function(){
        $("#organism_row").collapse("show");
        $("#mirna_row").collapse("show");
        $("#mirna_false").button("toggle");
        $("#fastq_help").collapse("show");
        $("#organism7").hide();
    });
    
    $("#organism_row .btn").click(function(){
        var x = $(this).attr("id");
        if (x == "organism6") {
            $("#mirna_false").button("toggle");
            $("#mirna_row").collapse("hide");
        }
        else {
            $("#mirna_row").collapse("show");
        }
    });

    $("#submit_user_data").click(function(){
        var validate_result = validate_user_data();
        if (validate_result) {
            submit_user_data();
        }
    });

    $("#urlSubmit").click(function(){
        var validate_result = validate_user_data();
        if (validate_result) {
            submit_user_data();
        }
    });

    $("#submit_srr").click(function(){
        set_sd(function (){save_user_data_before_upload();var validate_result = validate_user_data();if (validate_result) {submit_user_data();}});
    });
    $("#submit_url").click(function(){
        set_sd(function (){save_user_data_before_upload();var validate_result = validate_user_data();if (validate_result) {submit_user_data();}});
    });
    
    $("#login_form #authenticate").click(function(){
        login();
    });
    $("#logout").click(function(){
        logout();
    });

    /* fileupload bindings */ 
    var files4upload = [];
    var uploaded_files = 0;
    $('#fileupload').fileupload();
    myfileupload = $('#fileupload').fileupload({
        sequentialUploads: true,
        maxChunkSize: 50000000,
        autoUpload: false,
        maxRetries: 100,
        retryTimeout: 1000,
        fail: function (e, data) {
            // jQuery Widget Factory uses "namespace-widgetname" since version 1.10.0:
            console.log("Fail encountered!");
            var fu = $(this).data('blueimp-fileupload') || $(this).data('fileupload'),
                retries = data.context.data('retries') || 0,
                retry = function () {
                    console.log("retry=");
                    $.getJSON('/mara/get_size', {file: data.files[0].name, sd: $("#sd").val()})
                        .done(function (result) {
                            console.log(result);
                            console.log(result.file);
                            var file = result.file;
                            console.log(file.size);
                            data.uploadedBytes = file && file.size;
                            // clear the previous data:
                            data.data = null;
                            data.submit();
                        })
                        .fail(function () {
                            fu._trigger('fail', e, data);
                        });
                };
            if (data.errorThrown !== 'abort' &&
                data.uploadedBytes < data.files[0].size &&
                retries < fu.options.maxRetries) {
                console.log("inside if");
                retries += 1;
                data.context.data('retries', retries);
                window.setTimeout(retry, retries * fu.options.retryTimeout);
                return;
            }
            data.context.removeData('retries');
            $.blueimp.fileupload.prototype
                .options.fail.call(this, e, data);
        }
    });
    


   
    $('#fileupload').bind('fileuploadchange', function (e, data) {
        // set  working dir if not set
        if ($("#sd").val() == "") {
            set_sd();
        }
    });
    
    $('#fileupload').bind('fileuploadadd', function (e, data) {
        if (files4upload.indexOf(data.files[0].name) !== -1){
            alert("This file has been added already!!");
            return(false);
        }
    });
    
    $('#fileupload').bind('fileuploadadded', function (e, data) {
        if (data.files[0].error === null || data.files[0].error === undefined) {
            files4upload.push(data.files[0].name);
        }
    });

    $('#fileupload').bind('fileuploadfailed', function (e, data) {
        if (data.files[0].error === null || data.files[0].error === undefined) {
            files4upload.splice(files4upload.indexOf(data.files[0].name), 1);
        }
    });
    
    $('#fileupload').bind('fileuploadstarted', function (e, data) {
        $(".cancel").hide();
        save_user_data_before_upload();
    });

    $('#fileupload').bind('fileuploadcompleted', function (e, data) {
        uploaded_files += 1;
        if (uploaded_files === files4upload.length) {
            var validate_result = validate_user_data();
            if (validate_result) {
                submit_user_data();
            }
            else {
                $(".span7").hide();
                $("#submit_user_data").show();
                $("#brief_instructions").html("Please fill missing values and click \"Submit\" button.");
            }
        }
    });


    $('[data-toggle="tooltip"]').tooltip(); 

    /* Insert contact */
    var s = 'amlioth:ledpse@kxeapyso.grs?buejtc[=wSsiRsgeluno]';
    var r = '';
    for (var i=0; i<s.length; i++,i++){
        r = r+s.substring(i+1,i+2) + s.substring(i,i+1);
    }
    $("#contact p").html('<a href="' + r + '">ExPASy Helpdesk</a>');

    /* file upload option here to avoid messed highlighting in the web-mode emacs*/
    $('#fileupload').fileupload('option',{
        acceptFileTypes: /(\.|\/)(bed|cel|gz|bz2|zip|tar|bam|sam|fastq)$/i
    });
});
