/*global $:false */

function myFormatter(label, series) {
    if (series.lines.show == 0) {
        return(null)
    } 
    return(label);
}

function get_expr_mean(data) {
    var sum = 0;
    for (var i in data) {
        sum = sum + parseFloat(data[i]);
    }
    mean = sum / data.length
    return(mean);   
}


function get_min_max(data) {
    var min = data["data"][0][1];
    var max = data["data"][0][1];
    for (var i in data["data"]) {
        var value = data["data"][i][1];
        if (value > max) {
            max = value;
        } 
        else if (value < min) {
            min = value;
        }
    }
    return([min, max]);    
}

function make_expr_plot(data, samples, id, plots) {
    //console.log("data:");
    //console.log();
    var layout = {yaxis: {title: "Promoter expression (log2)"},
                  showlegend: true,
                  legend: {x: 1, y: 1.1},
                  xaxis: {type: 'category'}};
    Plotly.newPlot(id, data, layout);
    plots.push(id);
}


function sum_datasets(data1, data2) {
    for (var i in data1["data"]) {
        data1["data"][i][1] = data1["data"][i][1] + data2["data"][i][1];
    }
    return(data1);
}

function subtract_datasets(data1, data2) {
    for (var i in data1["data"]) {
        data1["data"][i][1] = data1["data"][i][1] - data2["data"][i][1];
    }
    return(data1);
}

function changeStatus(event) {
    //console.log(event);
    plotType = event.data.param1;
/*    var show = $(this).attr('show');
    if (show === "1" || show === undefined) {
        $(this).attr("show", "0");
        $(this).find("button").text("Off");
    }
    else {
        $(this).attr("show", "1");
        $(this).find("button").text("On");
    }*/
    if (plotType == "expr") {
        replot($(this));
    } else if (plotType == "act") {
        replot_act($(this), event.data.param2);
    }
}

function replot(elem) {
    //console.log(elem);
    //console.log($(elem).text());
    var label = $(elem).text();
    var plot_idx = parseInt($(elem).parents("div").data("prom-num"));
    var plot_data = plots[plot_idx].getData();
    for (var i in plot_data) {
        if (plot_data[i].label == label) {
            plot_data[i].lines.show = !plot_data[i].lines.show;
            break;
        }
    }
    plots[plot_idx].setData(plot_data);
    plots[plot_idx].draw();
    return("ok");
}

function replot_act(elem, prom_mat_expr) {
    var label = $(elem).data("mat-name");
    var state = $(elem).prop("checked");
    var prom = $(elem).data("prom-name");
    var prom_num = $(elem).data("prom-num");
    //console.log("elem:");
    //console.log(elem);
    //console.log("label:");
    //console.log(label);
    //console.log("state");
    //console.log(state);
    var plot = $(".act_plot_div[data-prom-num=" + prom_num + "]")[0]
    var plot_data = plot.data[1].y;
    //console.log(plot_data);
    var mat_expr_data = prom_mat_expr[prom][label]
    if (state) {
        for (var i = 0; i < plot_data.length; ++i) {
            plot_data[i] = plot_data[i] + mat_expr_data[i]
        }
    } else {
        for (var i = 0; i < plot_data.length; ++i) {
            plot_data[i] = plot_data[i] - mat_expr_data[i]
        }   
    }
    //console.log(plot_data);
    //console.log(".act_plot_div[data-prom-num=" + prom_num + "]");
    Plotly.restyle(plot, {"y":[plot_data], "layout":{"xaxis":{"type":"category"}}}, 1);
    return("ok");
}

function all_on(event) {
    prom_mat_expr = event.data.param1;
    var prom_num = $(this).data("prom-num");
    var prom = $(this).data("prom-name");
    var plot = $(".act_plot_div[data-prom-num=" + prom_num + "]")[0]
    var mean_data = plot.data[2].y;
    var pred_expr = mean_data.slice(); //copy array
    //console.log(pred_expr);
    for (motif in prom_mat_expr[prom]) {
        pred_expr = pred_expr.map(function(a,i){
            return(a + prom_mat_expr[prom][motif][i]);
        });
        //console.log(prom + " - " + motif);
        //console.log(pred_expr);
    }
    Plotly.restyle(plot, {"y":[pred_expr]}, 1);
    $(".prom_mat_table[data-prom-num=" + prom_num + "]").DataTable().column(0).nodes().to$().each(function (){
        $(this).children("input").prop("checked", true);
    });
}

function all_off(event) {
    prom_mean_expr = event.data.param1;
    var prom_num = $(this).data("prom-num");
    var prom = $(this).data("prom-name");
    var plot = $(".act_plot_div[data-prom-num=" + prom_num + "]")[0]
    var mean_data = plot.data[2].y
    var pred_expr = mean_data.slice(); //copy array
    Plotly.restyle(plot, {"y":[pred_expr]}, 1);
    $(".prom_mat_table[data-prom-num=" + prom_num + "]").DataTable().column(0).nodes().to$().each(function (){
        $(this).children("input").prop("checked", false);
    });
}
